*-------------------------------------------------------------------------------
/* title : Summary statistics of proxies
   source: World Input-Output Tables, 2016 Release (in Stata format)
   input : $temp/Sample.dta
   output: $output_tex/Table1b
		   $output_tex/Table3a
		   $output_tex/Table3b
		   $output_fig/Figure2 
		   $output_fig/Figure23
		   $output_fig/OnlineAppendix_FigureD2 */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*--------------------------------FIGURE STYLE-----------------------------------
* Graph scheme
set scheme s2color // s2color cleanplots 
grstyle init
grstyle set plain, nogrid noextend horizontal // compact
grstyle set legend 6
grstyle set legend, nobox
graph set window fontface "Times New Roman"

* File-types to export graphs
global filetype	pdf // pdf png eps

*===============================================================================
* Table 1b - Summary statistics of proxies
*===============================================================================
local proxies down0dIM up0dEX up0dIM down0dEX IM EX 	// Regressors in Markov process

use CPA country year `proxies' trend using "$temp/Sample.dta", clear
gcollapse (mean) `proxies' trend, by(CPA country year)

gen all = 1
estpost tabstat `proxies', by(all) stats(count mean sd min p25 p50 p75 max) nototal columns(statistics) 
estout . using "$output_tex/Table1b.tex", replace style(tex) mlabels(, none) collabels(, none) eqlabels(, none) ///
				cells("count(fmt(%9.0fc)) mean(fmt(%9.3f)) sd(fmt(%9.3f)) min(fmt(%9.3f)) p25(fmt(%9.3f)) p50(fmt(%9.3f)) p75(fmt(%9.3f)) max(fmt(%9.3f))") ///
				rename(down0dIM "$\!downIM\$" up0dEX "$\!upEX\$" up0dIM "$\!upIM\$" down0dEX "$\!downEX\$" IM "$\!IM\$" EX "$\!EX\$") substitute("$\!" "$")

*===============================================================================
* Table 3a & 3b - Correlation of proxies
*===============================================================================

* Correlation of proxies
correlate `proxies'
qui estpost correlate `proxies', matrix
esttab . using "$output_tex/Table3a.tex", replace style(tex) not unstack compress noobs nostar ///
				rename(down0dIM "$\!downIM\$" up0dEX "$\!upEX\$" up0dIM "$\!upIM\$" down0dEX "$\!downEX\$" IM "$\!IM\$" EX "$\!EX\$") 	///
				mlabels(, none) collabels(, none) eqlabels(, none) nonumbers fragment nodepvars varlabels(, nolast ) nolines plain 		///
				cells( "b(fmt(3))") substitute("\!" "") 


* De-mean proxies with FEs from Baseline model to uncover effective identifying variation used in regressions
gegen ic = group(country CPA)
gegen c = group(country)
qui foreach var of local proxies {
	reg `var' i.year i.CPA#c.trend i.c#c.trend i.ic 	// Add the last set of FE since all between variation in the regressions is eliminated by firm FEs
	predict `var'_res, residuals
}

* Correlation of demeaned proxies
local proxies down0dIM_res up0dEX_res up0dIM_res down0dEX_res IM_res EX_res
correlate `proxies'
qui estpost correlate `proxies', matrix
esttab . using "$output_tex/Table3b.tex", replace style(tex) not unstack compress noobs nostar ///
				rename(down0dIM_res "$\!downIM\$" up0dEX_res "$\!upEX\$" up0dIM_res "$\!upIM\$" down0dEX_res "$\!downEX\$" IM_res "$\!IM\$" EX_res "$\!EX\$") 	///
				mlabels(, none) collabels(, none) eqlabels(, none) nonumbers fragment nodepvars varlabels(, nolast ) nolines plain 								///
				cells( "b(fmt(3))") substitute("\!" "")

*===============================================================================
* Figure 2 - Trends of proxies over time
*===============================================================================
rename *0dIM *IM
rename *0dEX *EX

preserve
	gcollapse (mean) downIM upEX upIM downEX, by(year)

	* Plot sub-figures
	local num = 1
	foreach var in downIM upEX upIM downEX {
		twoway line `var' year, xtitle("") ytitle("") ylabel(minmax, format(%-9.2f)) xlab(2000 2004 2008 2011 2014) ///
								lcolor(black) lwidth(vthin) title("`var'") name(g`num', replace) 
		local ++num
	}

	* Combine sub-figures
	graph combine g1 g2 g3 g4, graphregion(margin(zero)) imargin(-9 2 -3 1) ycommon

	* Export figure
	foreach gtype of global filetype {
		graph export "$output_fig/Figure2.`gtype'", replace
	}
restore

graph drop _all

*===============================================================================
* Figure 3 - Boxplots of proxies over industries
*===============================================================================
sort CPA country year

* Plot sub-figures
local i = 1
foreach var in downIM upEX upIM downEX {
	graph box `var', noout over(CPA, axis(lstyle(none)) label(labsize(small))) bar(1, color(gs6) lcolor(black) lwidth(vthin)) ///
					 yscale(lstyle(none)) ylabel(, nogrid) note("") ytitle("") title("`var'") name(g`i',replace)
	local ++i
}

* Combine sub-figures
graph combine g1 g2 g3 g4, col(2) row(2) graphregion(margin(zero)) imargin(-5 -5 0 4) ycommon

* Export figure
foreach gtype of global filetype {
	graph export "$output_fig/Figure3.`gtype'", replace
}

*===============================================================================
* Online Appendix Figure D1 - Boxplots of proxies over years
*===============================================================================
* Plot sub-figures
local i = 1
foreach var in downIM upEX upIM downEX {
	graph box `var', noout over(year, axis(lstyle(none)) label(angle(45) labsize(small))) bar(1, color(gs6) lcolor(black) lwidth(vthin)) ///
					 yscale(lstyle(none)) ylabel(, nogrid) note("") ytitle("") title("`var'") name(g`i',replace)
	local ++i
}

* Combine sub-figures
graph combine g1 g2 g3 g4, col(2) row(2) graphregion(margin(zero)) imargin(-5 -5 0 4) ycommon

* Export figure
foreach gtype of global filetype {
	graph export "$output_fig/OnlineAppendix_FigureD1.`gtype'", replace
}

*===============================================================================
* Online Appendix Figure D2 - Boxplots of proxies over countries
*===============================================================================
* Plot sub-figures
local i = 1
foreach var in downIM upEX upIM downEX {
	graph box `var', noout over(country, axis(lstyle(none)) label(labsize(small))) bar(1, color(gs6) lcolor(black) lwidth(vthin)) ///
					 yscale(lstyle(none)) ylabel(, nogrid) note("") ytitle("") title("`var'") name(g`i',replace)
	local ++i
}

* Combine sub-figures
graph combine g1 g2 g3 g4, col(2) row(2) graphregion(margin(zero)) imargin(-5 -5 0 4) ycommon

* Export figure
foreach gtype of global filetype {
	graph export "$output_fig/OnlineAppendix_FigureD2.`gtype'", replace
}

graph drop _all
